<?php
require_once 'config.php';
require_once 'includes/DatabaseHelper.php';
require_once 'includes/TwilioHelper.php';

$dbHelper = new DatabaseHelper($db);
$twilioHelper = new TwilioHelper();

// Get the incoming message data
$from = $_POST['From'] ?? '';
$body = $_POST['Body'] ?? '';
$mediaUrl = $_POST['MediaUrl0'] ?? null;
$messageType = $mediaUrl ? 'media' : 'text';

// Clean the phone number
$phoneNumber = str_replace('whatsapp:', '', $from);

// Auto-add new subscribers
$dbHelper->addSubscriber($phoneNumber);

// Save the incoming message
$dbHelper->saveMessage(
    $phoneNumber,
    TWILIO_WHATSAPP_NUMBER,
    $body,
    $mediaUrl,
    $messageType
);

// Initialize response
header('Content-Type: text/xml');
echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<Response>
    <Message>
        <?php
        if (stripos($body, 'template:') === 0) {
            // Handle template request
            $templateName = trim(substr($body, 9));
            $templates = $dbHelper->getTemplates();
            $templateFound = false;
            
            foreach ($templates as $template) {
                if (strtolower($template['name']) === strtolower($templateName)) {
                    echo htmlspecialchars($template['content']);
                    $templateFound = true;
                    break;
                }
            }
            
            if (!$templateFound) {
                echo "Template not found!";
            }
        } else {
            // Default response
            echo "Thanks for your message! We'll get back to you soon.";
        }
        ?>
    </Message>
</Response>
