<?php
echo "Installing Twilio SDK...\n";

// Create vendor directory if it doesn't exist
if (!file_exists('vendor/twilio/sdk/src')) {
    mkdir('vendor/twilio/sdk/src', 0755, true);
}

// Download Twilio SDK
$url = 'https://github.com/twilio/twilio-php/archive/refs/tags/6.44.0.zip';
$zipFile = 'twilio.zip';

echo "Downloading Twilio SDK...\n";
file_put_contents($zipFile, file_get_contents($url));

echo "Extracting files...\n";
$zip = new ZipArchive;
if ($zip->open($zipFile) === TRUE) {
    $zip->extractTo('vendor/twilio/');
    $zip->close();
    
    // Move files to correct location
    rename('vendor/twilio/twilio-php-6.44.0/src', 'vendor/twilio/sdk/src');
    
    // Clean up
    unlink($zipFile);
    echo "Cleaning up temporary files...\n";
    
    echo "Installation complete!\n";
} else {
    echo "Failed to extract files\n";
}
?>
