<?php
require_once 'config.php';
require_once 'includes/DatabaseHelper.php';
require_once 'includes/TwilioHelper.php';

$dbHelper = new DatabaseHelper($db);
$twilioHelper = new TwilioHelper();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'send_message':
            $to = $_POST['phone_number'];
            $message = $_POST['message'];
            $mediaUrl = $_POST['media_url'] ?? null;
            
            $result = $twilioHelper->sendMessage($to, $message, $mediaUrl);
            if ($result['success']) {
                $dbHelper->saveMessage(TWILIO_WHATSAPP_NUMBER, $to, $message, $mediaUrl);
            }
            break;
            
        case 'create_template':
            $name = $_POST['template_name'];
            $content = $_POST['template_content'];
            $dbHelper->saveTemplate($name, $content);
            break;
            
        case 'send_broadcast':
            $message = $_POST['broadcast_message'];
            $subscribers = $dbHelper->getAllSubscribers();
            $broadcastId = $dbHelper->createBroadcast($message);
            
            if ($broadcastId) {
                $results = $twilioHelper->sendBroadcast($message, $subscribers);
                $successCount = count(array_filter($results, function($r) { return $r['status']; }));
                $dbHelper->updateBroadcastStatus($broadcastId, $successCount, 'completed');
            }
            break;
    }
}

// Get data for display
$subscribers = $dbHelper->getAllSubscribers();
$templates = $dbHelper->getTemplates();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>WhatsApp Chat Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .chat-container {
            height: 500px;
            overflow-y: auto;
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        .message {
            margin-bottom: 10px;
            padding: 10px;
            border-radius: 5px;
        }
        .received {
            background-color: #f1f0f0;
            margin-right: 20%;
        }
        .sent {
            background-color: #dcf8c6;
            margin-left: 20%;
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <h2 class="mb-4">WhatsApp Chat Dashboard</h2>
        
        <div class="row">
            <!-- Chat Section -->
            <div class="col-md-8">
                <div class="card mb-4">
                    <div class="card-header">
                        Send Message
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <input type="hidden" name="action" value="send_message">
                            <div class="mb-3">
                                <label class="form-label">Phone Number</label>
                                <input type="text" class="form-control" name="phone_number" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Message</label>
                                <textarea class="form-control" name="message" required></textarea>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Media URL (optional)</label>
                                <input type="url" class="form-control" name="media_url">
                            </div>
                            <button type="submit" class="btn btn-primary">Send Message</button>
                        </form>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header">
                        Message Templates
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <input type="hidden" name="action" value="create_template">
                            <div class="mb-3">
                                <label class="form-label">Template Name</label>
                                <input type="text" class="form-control" name="template_name" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Template Content</label>
                                <textarea class="form-control" name="template_content" required></textarea>
                            </div>
                            <button type="submit" class="btn btn-success">Create Template</button>
                        </form>
                        
                        <hr>
                        
                        <h5>Existing Templates</h5>
                        <div class="list-group">
                            <?php foreach ($templates as $template): ?>
                            <div class="list-group-item">
                                <h6><?= htmlspecialchars($template['name']) ?></h6>
                                <p class="mb-1"><?= htmlspecialchars($template['content']) ?></p>
                                <small class="text-muted">Created: <?= $template['created_at'] ?></small>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Subscribers and Broadcast Section -->
            <div class="col-md-4">
                <div class="card mb-4">
                    <div class="card-header">
                        Send Broadcast
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <input type="hidden" name="action" value="send_broadcast">
                            <div class="mb-3">
                                <label class="form-label">Broadcast Message</label>
                                <textarea class="form-control" name="broadcast_message" required></textarea>
                            </div>
                            <button type="submit" class="btn btn-warning">Send Broadcast</button>
                        </form>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        Subscribers (<?= count($subscribers) ?>)
                    </div>
                    <div class="card-body">
                        <div class="list-group">
                            <?php foreach ($subscribers as $subscriber): ?>
                            <div class="list-group-item">
                                <h6><?= htmlspecialchars($subscriber['phone_number']) ?></h6>
                                <?php if ($subscriber['name']): ?>
                                <p class="mb-1"><?= htmlspecialchars($subscriber['name']) ?></p>
                                <?php endif; ?>
                                <small class="text-muted">Joined: <?= $subscriber['created_at'] ?></small>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
