<?php
require_once __DIR__ . '/../vendor/autoload.php';
use Twilio\Rest\Client;

class TwilioHelper {
    private $client;
    private $whatsappNumber;

    public function __construct() {
        $this->client = new Client(TWILIO_ACCOUNT_SID, TWILIO_AUTH_TOKEN);
        $this->whatsappNumber = TWILIO_WHATSAPP_NUMBER;
    }

    public function sendMessage($to, $message, $mediaUrl = null) {
        try {
            $messageArray = [
                'from' => "whatsapp:{$this->whatsappNumber}",
                'body' => $message,
                'to' => "whatsapp:{$to}"
            ];

            if ($mediaUrl) {
                $messageArray['mediaUrl'] = [$mediaUrl];
            }

            $message = $this->client->messages->create(
                "whatsapp:{$to}",
                $messageArray
            );

            return [
                'success' => true,
                'message_sid' => $message->sid
            ];
        } catch (Exception $e) {
            return [
                'success' => false,
                'error' => $e->getMessage()
            ];
        }
    }

    public function sendBroadcast($message, $subscribers) {
        $results = [];
        foreach ($subscribers as $subscriber) {
            $result = $this->sendMessage($subscriber['phone_number'], $message);
            $results[] = [
                'phone' => $subscriber['phone_number'],
                'status' => $result['success']
            ];
        }
        return $results;
    }
}
?>
