<?php
class DatabaseHelper {
    private $db;

    public function __construct($db) {
        $this->db = $db;
    }

    public function addSubscriber($phoneNumber, $name = null) {
        try {
            $stmt = $this->db->prepare("INSERT IGNORE INTO subscribers (phone_number, name) VALUES (?, ?)");
            return $stmt->execute([$phoneNumber, $name]);
        } catch (PDOException $e) {
            error_log("Error adding subscriber: " . $e->getMessage());
            return false;
        }
    }

    public function getAllSubscribers() {
        try {
            $stmt = $this->db->query("SELECT * FROM subscribers ORDER BY created_at DESC");
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            error_log("Error getting subscribers: " . $e->getMessage());
            return [];
        }
    }

    public function saveMessage($sender, $receiver, $message, $mediaUrl = null, $messageType = 'text') {
        try {
            $stmt = $this->db->prepare(
                "INSERT INTO messages (sender, receiver, message, media_url, message_type) 
                 VALUES (?, ?, ?, ?, ?)"
            );
            return $stmt->execute([$sender, $receiver, $message, $mediaUrl, $messageType]);
        } catch (PDOException $e) {
            error_log("Error saving message: " . $e->getMessage());
            return false;
        }
    }

    public function getMessages($phoneNumber) {
        try {
            $stmt = $this->db->prepare(
                "SELECT * FROM messages 
                 WHERE sender = ? OR receiver = ? 
                 ORDER BY created_at DESC 
                 LIMIT 100"
            );
            $stmt->execute([$phoneNumber, $phoneNumber]);
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            error_log("Error getting messages: " . $e->getMessage());
            return [];
        }
    }

    public function saveTemplate($name, $content) {
        try {
            $stmt = $this->db->prepare("INSERT INTO templates (name, content) VALUES (?, ?)");
            return $stmt->execute([$name, $content]);
        } catch (PDOException $e) {
            error_log("Error saving template: " . $e->getMessage());
            return false;
        }
    }

    public function getTemplates() {
        try {
            $stmt = $this->db->query("SELECT * FROM templates ORDER BY created_at DESC");
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            error_log("Error getting templates: " . $e->getMessage());
            return [];
        }
    }

    public function createBroadcast($message) {
        try {
            $stmt = $this->db->prepare("INSERT INTO broadcasts (message) VALUES (?)");
            $stmt->execute([$message]);
            return $this->db->lastInsertId();
        } catch (PDOException $e) {
            error_log("Error creating broadcast: " . $e->getMessage());
            return false;
        }
    }

    public function updateBroadcastStatus($id, $sentTo, $status) {
        try {
            $stmt = $this->db->prepare(
                "UPDATE broadcasts 
                 SET sent_to = ?, status = ? 
                 WHERE id = ?"
            );
            return $stmt->execute([$sentTo, $status, $id]);
        } catch (PDOException $e) {
            error_log("Error updating broadcast: " . $e->getMessage());
            return false;
        }
    }
}
?>
