<?php
// Simple Autoloader
spl_autoload_register(function ($class) {
    $prefix = 'Twilio\\';
    $base_dir = __DIR__ . '/vendor/twilio/sdk/src/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});

define('DB_HOST', 'localhost');
define('DB_USER', 'your_db_user');
define('DB_PASS', 'your_db_password');
define('DB_NAME', 'whatsapp_chat');

// Twilio Configuration
define('TWILIO_ACCOUNT_SID', 'AC02b12b78e67eb306bf8f10b6a8ea0b2c');
define('TWILIO_AUTH_TOKEN', '28b8c438628f7f7cf195e24334c6f691');
define('TWILIO_WHATSAPP_NUMBER', '+17815566423');

// Initialize Database Connection
try {
    $db = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME,
        DB_USER,
        DB_PASS,
        array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES 'utf8'")
    );
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    error_log("Connection Error: " . $e->getMessage());
    exit;
}
?>
