# WhatsApp Chat System with Twilio Integration

A PHP-based WhatsApp chat system that uses Twilio for WhatsApp integration. Features include live chat, media sharing, message templates, and broadcast messaging.

## Features

- Send and receive WhatsApp messages
- Handle media messages (images, voice)
- Create and use message templates
- Send broadcast messages
- Auto-add new chat participants as subscribers
- Modern web interface
- MySQL database for data storage

## Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache web server
- Composer
- Twilio account with WhatsApp capabilities

## Installation

1. Clone the repository to your web server directory:
   ```bash
   git clone [repository-url] /var/www/html/whatsapp-chat
   ```

2. Install dependencies using Composer:
   ```bash
   cd /var/www/html/whatsapp-chat
   composer install
   ```

3. Create the MySQL database:
   ```bash
   mysql -u your_user -p < database.sql
   ```

4. Configure your database credentials in `config.php`:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_USER', 'your_db_user');
   define('DB_PASS', 'your_db_password');
   define('DB_NAME', 'whatsapp_chat');
   ```

5. Update Twilio credentials in `config.php`:
   ```php
   define('TWILIO_ACCOUNT_SID', 'your_account_sid');
   define('TWILIO_AUTH_TOKEN', 'your_auth_token');
   define('TWILIO_WHATSAPP_NUMBER', 'your_whatsapp_number');
   ```

6. Set proper permissions:
   ```bash
   chmod 755 /var/www/html/whatsapp-chat
   chmod 644 /var/www/html/whatsapp-chat/.htaccess
   ```

7. Configure your web server:
   - Make sure mod_rewrite is enabled
   - Set the document root to the project directory
   - Enable .htaccess files

8. Configure Twilio webhook:
   - Log into your Twilio console
   - Set the webhook URL to: https://your-domain.com/webhook.php
   - Make sure to use HTTPS

## Security

- All sensitive files are protected through .htaccess
- Database credentials are stored securely
- HTTPS is enforced
- Input validation and sanitization implemented
- Error logging is enabled
- Display errors are disabled in production

## Directory Structure

```
whatsapp-chat/
├── includes/
│   ├── DatabaseHelper.php
│   └── TwilioHelper.php
├── .htaccess
├── composer.json
├── config.php
├── database.sql
├── index.php
├── README.md
└── webhook.php
```

## Usage

1. Access the dashboard at: https://your-domain.com/
2. Send messages:
   - Enter the recipient's phone number
   - Type your message
   - Optionally add a media URL
   - Click Send

3. Create templates:
   - Enter template name and content
   - Save template
   - Use template by sending "template:name" in WhatsApp

4. Send broadcasts:
   - Type your broadcast message
   - Click Send Broadcast
   - Message will be sent to all subscribers

## Maintenance

- Regularly backup your database
- Monitor error logs
- Keep PHP and all dependencies updated
- Regularly rotate Twilio credentials

## License

MIT License
